'=============================================================================
'                           RAYCASTING TUTORIAL #6
'                                By Joe King
'
'                            Imporving raycasters
'=============================================================================

'   This program has colored walls.  Most of the REM statements are gone from
' the other raycaster tutorials because you should know how that stuff works.
'   This times by 1024 instead of 1000, because 1024 is good and will help
' you if you want to do textures.  And instead of timesing the tables by 100,
' I used 1024/10 because I want the ray to be casted out 10 times in 1 square
' on the map grid.  And this has color walls for the map grid.

'***** The code *****
'=============================================================================

  DIM SinTable(359) AS INTEGER
  DIM CosTable(359) AS INTEGER
  DIM Map%(10, 10)

  CONST PI = 3.14159
 
FOR z% = 0 TO 359
  SinTable(z%) = SIN(z% * PI / 180) * 1024 \ 10
  CosTable(z%) = COS(z% * PI / 180) * 1024 \ 10
NEXT z%

FOR y% = 1 TO 10
FOR x% = 1 TO 10
  READ Map%(x%, y%)
    IF Map%(x%, y%) = -1 THEN   '***** -1 is the starting position on the map.
      Map%(x%, y%) = 0
      px% = x%
      py% = y%
    END IF
NEXT x%
NEXT y%

  px% = px% * 1024
  py% = py% * 1024

  SCREEN 13           '***** I used screen 13 instead of screen 7, because
                      '***** screen 13 is faster and has more colors.

  Angle% = 0
  SkyColor% = 9
  FloorColor% = 24

DO
  GOSUB Raycast
  DO
  a$ = INKEY$
  LOOP WHILE a$ = ""
  opx% = px%: opy% = py%      '***** Make old positions for the coordinates
                              '***** incase you hit a wall and want to move
                              '***** back to it.

  IF a$ = CHR$(0) + "H" THEN px% = px% - SinTable(Angle%) * 5: py% = py% - CosTable(Angle%) * 5
  IF a$ = CHR$(0) + "P" THEN px% = px% + SinTable(Angle%) * 5: py% = py% + CosTable(Angle%) * 5
  IF a$ = CHR$(0) + "K" THEN Angle% = Angle% - 5
  IF a$ = CHR$(0) + "M" THEN Angle% = Angle% + 5
  IF a$ = CHR$(27) THEN END

  IF Angle% < 0 THEN Angle% = Angle% + 360
  IF Angle% > 359 THEN Angle% = Angle% - 360

  '***** Check if you hit a wall *****
  '***** If you did, send you back to your old positions (opx%,opy%) *****
  IF Map%(px% \ 1024, py% \ 1024) THEN px% = opx%: py% = opy%

LOOP

'***** The raycasting routine *****
Raycast:

s% = -5

FOR z% = -31 TO 32

  s% = s% + 5
 
  a% = Angle% + z%
  IF a% < 0 THEN a% = a% + 360
  IF a% > 359 THEN a% = a% - 360

  xx% = px%: yy% = py%
  StepX% = SinTable(a%) '***** Makes a variable for the run(step x)
  StepY% = CosTable(a%) '***** Makes a variable for the rise(step y)

  dd% = 0

  DO
    xx% = xx% - StepX%
    yy% = yy% - StepY%
    m% = Map%(xx% \ 1024, yy% \ 1024)
    dd% = dd% + 1
  LOOP UNTIL m%

  ds% = 1000 \ dd%

  LINE (s%, 0)-(s% + 4, 99 - ds%), SkyColor%, BF
  '***** m% is the number on the map grid, also the color of the wall
  LINE (s%, 100 - ds%)-(s% + 4, 100 + ds%), m%, BF
  LINE (s%, 101 + ds%)-(s% + 4, 200), FloorColor%, BF

NEXT z%

RETURN

'***** The data for the map grid *****
'***** The numbers above 0 are the colors of the walls *****
'***** -1 is your starting position *****
'=============================================================================
DATA  1, 5, 1, 5, 1, 5, 1, 5, 1, 5
DATA  3, 0, 0, 0, 0, 0, 0, 0, 0, 2
DATA  4, 0, 1, 0, 0, 0, 2, 4, 0, 5
DATA  3, 0, 1, 0, 0, 0, 4, 2, 0, 2
DATA  4, 0, 1, 0, 0, 0, 0, 0, 0, 5
DATA  3, 0, 1, 0,-1, 0, 0, 0, 0, 2
DATA  4, 0, 0, 0, 0, 0, 6, 0, 6, 7
DATA  3, 0,10,12,10,12, 0, 0, 0, 7
DATA  4, 0, 0, 0, 0, 0, 0, 0, 0, 7
DATA  8, 7, 8, 7, 8, 7, 8, 7, 8, 7

'***** End of code *****
'=============================================================================


